from scrapetube import get_channel, get_playlist, get_search


def list_playlist_videos(playlist_id, limit=None, sleep=1, proxies=None):
    return list(get_playlist(playlist_id, limit=limit, sleep=sleep, proxies=proxies))


def list_channel_videos(channel_id=None, channel_url=None, channel_username=None, limit=None, sleep=1, proxies=None, sort_by="newest", content_type="videos"):
    return list(
        get_channel(
            channel_id=channel_id,
            channel_url=channel_url,
            channel_username=channel_username,
            limit=limit,
            sleep=sleep,
            proxies=proxies,
            sort_by=sort_by,
            content_type=content_type,
        )
    )


def list_search(query, limit=None, sleep=1, sort_by="relevance", results_type="video", proxies=None):
    return list(get_search(query, limit=limit, sleep=sleep, sort_by=sort_by, results_type=results_type, proxies=proxies))


def list_playlists(target, limit=None, sleep=1, proxies=None):
    if target and 'list=' in target:
        playlist_id = target.split('list=')[-1].split('&')[0]
        return list_playlist_videos(playlist_id, limit=limit, sleep=sleep, proxies=proxies)
    return list(get_search(target or '', limit=limit, sleep=sleep, results_type='playlist', proxies=proxies))
